function [GISINTENSITY, c, GISheader, LU_endogenous, LU_exogenous, dairy_coef, dairy_scaling_coef, sheep_scaling_coef ] = LUIM1_load_data(pixel_size, output_path)
%
% Land Use Intensity Module - function 1 (LUIM1)
%
% This file loads the maps of land use from the allocation module and the
% maps relevant to land use intensity.
%
% The preparation of the vectorized map is handled outside of LURNZ in a
% map setup function.

% Code by Simon Anastasiadis : 2012-01-13

%% Parameters

% path for data
load_path = '..\Data for Modules\Data 3 Land Use Intensity Module';
% path for land use change
LUAM_path = [output_path, '\Results 2 Land Use Allocation Module'];

% info for loading coefficients
% coefficent file
coef_file_name = '\coefficients Timar 2013.xlsx';
% sheet names
dairy_sheet_name = 'dairy';
sheep_sheet_name = 'sheepbeef';
% coefficient ranges
dairy_coef_range = 'C4:G20';
dairy_scaling_coef_range = 'G42';
sheep_scaling_coef_range = 'G36';
% specified according to instructions in xlsread file (supporting code)
% call: "help xlsread" from Matlab prompt

%% Place holders for variables that will be loaded

LU_endogenous = [];
LU_exogenous = [];

GISINTENSITY = [];
c = [];
GISheader = [];

%% Load Land Use Allocation Module Output

load([LUAM_path,'\LUAM_output_data'],'LU_endogenous');
load([LUAM_path,'\LUAM_output_data'],'LU_exogenous');

%% Load GIS data

load([load_path,'\LUIM_input_data_',num2str(pixel_size),'ha'],'GISINTENSITY');
load([load_path,'\LUIM_input_data_',num2str(pixel_size),'ha'],'GISheader');
load([load_path,'\LUIM_input_data_',num2str(pixel_size),'ha'],'c');

%% Load coefficients
% GIS data loading is complete, now load coefficients

% dairy coefficents
dairy_coef = xlsread([load_path,coef_file_name],dairy_sheet_name,dairy_coef_range);
dairy_scaling_coef = xlsread([load_path,coef_file_name],dairy_sheet_name,dairy_scaling_coef_range);

% sheep beef scaling coefficient
sheep_scaling_coef = xlsread([load_path,coef_file_name],sheep_sheet_name,sheep_scaling_coef_range);

%% Inform User loading data is complete

msg = sprintf(' - - LUIM1 : loading data complete');
disp(msg)

end
